/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) OriginLab Corp.	2005, 2006, 2007, 2008, 2009, 2010			*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

#include	<XFbase.h>


// The example shows how to call an X-Function and get the result via OriginC
// XFbase.h is included for accessing the class XFBase.
// A typical process of using XFBase will be  
//
void	Call_XF_from_OC_Ex01()
{
	///////////////// Generate the data and save to worksheet /////////////////////////////
	vector vX;
	vector vY;

	vX.Data(0., 20.0, 0.05);
	vY.SetSize(vX.GetSize());
	double dA = 100.0;
	double dXc = 8.0;
	double dW = 2.0;
	vY = dA * exp(-0.5*(vX-dXc)*(vX-dXc)/dW/dW);
	
	Worksheet wks;
	wks.Create("origin");
	while(wks.Columns.Count()<6) wks.AddCol();
	wks.SetColDesignations("XY");
	wks.Columns(1).SetLongName("Raw");
	wks.Columns(3).SetLongName("Integration");
	wks.Columns(5).SetLongName("Normalized");
	
	DataRange drIn;
	drIn.Add(wks,0,"X");
	drIn.Add(wks,1,"Y");
	if(!drIn.SetData(&vY, &vX)) 
	{
		out_str("Failed to set the data!");	
		return;
	}
		

	//////////////// Call X-Function integ1 to do the integration and plotting.//////////

	//// Load the X-Function
	string		strXFNameToCall = "integ1";
	XFBase		xf(strXFNameToCall);
	if( !xf.IsValid() )
	{
		out_str("Failed to load xfunction.");
		return;
	}
	//// Set the arguments for the X-Function
	// Prototype for X-Function integ1.
	//	void integ1(const XYRange& yi, const int& baseline, const int& type, XYRange& yo, const int& plot,
	//	const int& color, double& x1, double& x2, int& i1, int& i2, double& area, double& y0, double& x0, double& dx)
	DataRange drInteg;
	drInteg.Add(wks, 2, "X");
	drInteg.Add(wks, 3, "Y");
	double dArea; 
	// DataRange can be directly passed as the arguments though the prototype for the argument is XYRange because class XYRange is derived from class DataRange.
	// We need get the result of integrated area, so set the 9th argument (area) separately.
	if ( !xf.SetArgs(drIn, 0, 1, drInteg, 1) || !xf.SetArg(10, dArea) )  
	{
		out_str("Failed to set the arguments!");
		return;
	}
	//// Execute the X-Function
	if ( !xf.Evaluate())
	{
		out_str("Failed to execute the X-Function!");
		return;
	}
	
	
	////////////////// Use the result of integ1 to do some calculation. ///////////////
	vector vXInteg;
	vector vYInteg;
	vector vYNorm;
	DataRange drNorm;
	drNorm.Add(wks, 4, "X");
	drNorm.Add(wks, 5, "Y");
	drInteg.GetData(vXInteg, 0);
	drInteg.GetData(vYInteg, 1);
	vYNorm = vYInteg/dArea;
	if( !drNorm.SetData(&vYNorm, &vXInteg) )
	{
		out_str("Failed to set the normalized data!");
		return;
	}
	// Plot the normalized curve.
	GraphPage gp;
	gp.Create("Origin");
	GraphLayer gl = gp.Layers();
	gl.AddPlot(drNorm,IDM_PLOT_LINE);
	gl.Rescale();
}
